[Setup]
AppName=SoundResourceDemo
AppVerName=1.0
DefaultDirName={pf}\SoundResourceDemo
OutputDir=Output

RawDataResource=SndA:bugreporter_succeeded.wav |SndB:buttonclickreleaseo.WAV


[Components]
Name: "main"; Description: "Main Files";
Name: "main\a"; Description: "A Files";
Name: "main\b"; Description: "B Files";


[code]
#define A = (Defined UNICODE) ? "W" : "A"

type
    HINST = THandle;
    HMODULE = HINST;
    Pointer = Longint;
    HRSRC = THandle;
    HGLOBAL = THandle;

const
    SND_ASYNC           = $0001;
    SND_NODEFAULT       = $0002;
    SND_MEMORY          = $0004;
    RT_RCDATA           = 10;


function sndPlaySound(lpszSoundName: Pointer; uFlags: UINT): BOOL; external 'sndPlaySound{#A}@Winmm.dll stdcall';
function LoadResource(hModule: HINST; hResInfo: HRSRC): HGLOBAL; external 'LoadResource@kernel32.dll stdcall';
function FindResource(hModule: HMODULE; lpName: String; lpType: Longint): HRSRC; external 'FindResource{#A}@kernel32.dll stdcall';
function LockResource(hResData: HGLOBAL): Pointer; external 'LockResource@kernel32.dll stdcall';

var
    pSoundMemory_A, pSoundMemory_B: Pointer;
    
function GetResourceSoundAddr(const ResourceName: String): Pointer;
var
    hResourceSound: HRSRC;
begin
    hResourceSound := FindResource(HInstance, ResourceName, RT_RCDATA);
    Result := LockResource(LoadResource(HInstance, hResourceSound));
end;

procedure ComponentsOnClickCheck(Sender: TObject);
begin
    sndPlaySound(pSoundMemory_B, SND_MEMORY or SND_NODEFAULT or SND_ASYNC);
end;

var
    LastIndex: Integer;

procedure ComponentsItemsMouseMove(Sender: TObject; X, Y: Integer; Index: Integer; Area: TItemArea);
begin
    if Index = -1 then
    begin
        LastIndex := -1;
        Exit;
    end;
        
    if LastIndex = -1 then
    begin
        LastIndex := Index;
        sndPlaySound(pSoundMemory_A, SND_MEMORY or SND_NODEFAULT or SND_ASYNC);
    end else
    if LastIndex = Index then Exit else
    if LastIndex <> Index then
    begin
        LastIndex := Index;
        sndPlaySound(pSoundMemory_A, SND_MEMORY or SND_NODEFAULT or SND_ASYNC);
    end;
end;


procedure InitializeWizard();
begin
    LastIndex := -1;

    pSoundMemory_A := GetResourceSoundAddr('_IS_SNDA');
    pSoundMemory_B := GetResourceSoundAddr('_IS_SNDB');
    
    WizardForm.ComponentsList.OnItemMouseMove := @ComponentsItemsMouseMove;
    WizardForm.ComponentsList.OnClickCheck := @ComponentsOnClickCheck;
end;




